<?php namespace Dzy\Slideshow\Components;

use Redirect;
use Cms\Classes\Page;
use Cms\Classes\ComponentBase;
use Dzy\Slideshow\Models\Post as SlideshowPost;

class Posts extends ComponentBase
{
    /**
     * A collection of posts to display
     * @var Collection
     */
    public $posts;

    /**
     * Parameter to use for the page number
     * @var string
     */
    public $pageParam;

    /**
     * Message to display when there are no messages.
     * @var string
     */
    public $noPostsMessage;

    /**
     * Paginator display.
     * @var string
     */
    public $paginator;

    /**
     * Reference to the page name for linking to posts.
     * @var string
     */
    public $postPage;


    /**
     * If the post list should be ordered by anslideshow attribute.
     * @var string
     */
    public $sortOrder;

    public function componentDetails()
    {
        return [
            'name'        => 'Slideshows',
            'description' => 'Display posts in Slideshow'
        ];
    }

    public function defineProperties()
    {
        return [
            'pageNumber' => [
                'title'       => 'Número da pagina',
                'description' => 'Esse valor é usado para determinar qual página o usuário está.',
                'type'        => 'string',
                'default'     => '{{ :page }}',
            ],
            'postsPerPage' => [
                'title'             => 'Posts por página',
                'type'              => 'string',
                'validationPattern' => '^[0-9]+$',
                'validationMessage' => 'Formato inválido das mensagens por valor de página',
                'default'           => '10',
            ],
            'noPostsMessage' => [
                'title'        => 'Nenhuma mensagem de posts',
                'description'  => 'Mensagem para exibir na lista post no caso, se não há mensagens. Esta propriedade é usada pelo componente default parcial.',
                'type'         => 'string',
                'default'      => 'No posts found',
                'showExternalParam' => false
            ],
            'sortOrder' => [
                'title'       => 'Orde posts',
                'description' => 'Atributo em que as mensagens devem ser ordenados',
                'type'        => 'dropdown',
                'default'     => 'published_at desc'
            ],
        ];
    }


    public function getPostPageOptions()
    {
        return Page::sortBy('baseFileName')->lists('baseFileName', 'baseFileName');
    }

    public function getSortOrderOptions()
    {
        return SlideshowPost::$allowedSortingOptions;
    }

    public function onRun()
    {
        $this->prepareVars();

        $this->posts = $this->page['posts'] = $this->listPosts();

        /*
         * If the page number is not valid, redirect
         */
        if ($pageNumberParam = $this->paramName('pageNumber')) {
            $currentPage = $this->property('pageNumber');

            if ($currentPage > ($lastPage = $this->posts->lastPage()) && $currentPage > 1)
                return Redirect::to($this->currentPageUrl([$pageNumberParam => $lastPage]));
        }
    }

    protected function prepareVars()
    {
        $this->pageParam = $this->page['pageParam'] = $this->paramName('pageNumber');
        $this->noPostsMessage = $this->page['noPostsMessage'] = $this->property('noPostsMessage');
        $this->paginator = $this->page['paginator'] = $this->property('paginator');

        /*
         * Page links
         */
        $this->postPage = $this->page['postPage'] = $this->property('postPage');
    }

    protected function listPosts()
    {

        /*
         * List all the posts, eager load their categories
         */
        $posts = SlideshowPost::listFrontEnd([
            'page'       => $this->property('pageNumber'),
            'sort'       => $this->property('sortOrder'),
            'perPage'    => $this->property('postsPerPage'),
            'search'     => trim(input('search')),
            'exceptPost' => $this->property('exceptPost'),
        ]);

         /*
         * Add a "url" helper attribute for linking to each post and category
         */
        $posts->each(function($post) {
            $post->setUrl($this->postPage, $this->controller);

        });


        return $posts;
    }

}
