<?php namespace Dzy\Projetos\Components;

use Response;
use Redirect;
use Cms\Classes\Page;
use Cms\Classes\ComponentBase;
use Dzy\Projetos\Models\Post as ProjetosPost;
use Dzy\Projetos\Models\Category as ProjetosCategory;

class RssFeed extends ComponentBase
{
    /**
     * A collection of posts to display
     * @var Collection
     */
    public $posts;

    /**
     * If the post list should be filtered by a category, the model to use.
     * @var Model
     */
    public $category;

    /**
     * Reference to the page name for the main projetos page.
     * @var string
     */
    public $projetosPage;

    /**
     * Reference to the page name for linking to posts.
     * @var string
     */
    public $postPage;

    public function componentDetails()
    {
        return [
            'name'        => 'dzy.projetos::lang.settings.rssfeed_title',
            'description' => 'dzy.projetos::lang.settings.rssfeed_description'
        ];
    }

    public function defineProperties()
    {
        return [
            'categoryFilter' => [
                'title'       => 'dzy.projetos::lang.settings.posts_filter',
                'description' => 'dzy.projetos::lang.settings.posts_filter_description',
                'type'        => 'string',
                'default'     => ''
            ],
            'sortOrder' => [
                'title'       => 'dzy.projetos::lang.settings.posts_order',
                'description' => 'dzy.projetos::lang.settings.posts_order_description',
                'type'        => 'dropdown',
                'default'     => 'created_at desc',
            ],
            'postsPerPage' => [
                'title'             => 'dzy.projetos::lang.settings.posts_per_page',
                'type'              => 'string',
                'validationPattern' => '^[0-9]+$',
                'validationMessage' => 'dzy.projetos::lang.settings.posts_per_page_validation',
                'default'           => '10',
            ],
            'projetosPage' => [
                'title'       => 'dzy.projetos::lang.settings.rssfeed_projetos',
                'description' => 'dzy.projetos::lang.settings.rssfeed_projetos_description',
                'type'        => 'dropdown',
                'default'     => 'projetos/post',
                'group'       => 'Links',
            ],
            'postPage' => [
                'title'       => 'dzy.projetos::lang.settings.posts_post',
                'description' => 'dzy.projetos::lang.settings.posts_post_description',
                'type'        => 'dropdown',
                'default'     => 'projetos/post',
                'group'       => 'Links',
            ],
        ];
    }

    public function getProjetosPageOptions()
    {
        return Page::sortBy('baseFileName')->lists('baseFileName', 'baseFileName');
    }

    public function getPostPageOptions()
    {
        return Page::sortBy('baseFileName')->lists('baseFileName', 'baseFileName');
    }

    public function getSortOrderOptions()
    {
        return ProjetosPost::$allowedSortingOptions;
    }

    public function onRun()
    {
        $this->prepareVars();

        $xmlFeed = $this->renderPartial('@default');

        return Response::make($xmlFeed, '200')->header('Content-Type', 'text/xml');
    }

    protected function prepareVars()
    {
        $this->projetosPage = $this->page['projetosPage'] = $this->property('projetosPage');
        $this->postPage = $this->page['postPage'] = $this->property('postPage');
        $this->category = $this->page['category'] = $this->loadCategory();
        $this->posts = $this->page['posts'] = $this->listPosts();

        $this->page['link'] = $this->pageUrl($this->projetosPage);
        $this->page['rssLink'] = $this->currentPageUrl();
    }

    protected function listPosts()
    {
        $category = $this->category ? $this->category->id : null;

        /*
         * List all the posts, eager load their categories
         */
        $posts = ProjetosPost::with('categories')->listFrontEnd([
            'sort'       => $this->property('sortOrder'),
            'perPage'    => $this->property('postsPerPage'),
            'category'   => $category
        ]);

        /*
         * Add a "url" helper attribute for linking to each post and category
         */
        $posts->each(function($post) {
            $post->setUrl($this->postPage, $this->controller);
        });

        return $posts;
    }

    protected function loadCategory()
    {
        if (!$categoryId = $this->property('categoryFilter'))
            return null;

        if (!$category = ProjetosCategory::whereSlug($categoryId)->first())
            return null;

        return $category;
    }
}
