<?php namespace Dzy\Projetos;

use Backend;
use Controller;
use Dzy\Projetos\Models\Post;
use System\Classes\PluginBase;
use Dzy\Projetos\Classes\TagProcessor;
use Dzy\Projetos\Models\Category;
use Event;

class Plugin extends PluginBase
{
    public function pluginDetails()
    {
        return [
            'name'        => 'dzy.projetos::lang.plugin.name',
            'description' => 'dzy.projetos::lang.plugin.description',
            'author'      => 'Alexey Bobkov, Samuel Georges',
            'icon'        => 'icon-pencil',
            'homepage'    => 'https://github.com/dzy/projetos-plugin'
        ];
    }

    public function registerComponents()
    {
        return [
            'Dzy\Projetos\Components\Post'       => 'projetosPost',
            'Dzy\Projetos\Components\Posts'      => 'projetosPosts',
            'Dzy\Projetos\Components\Categories' => 'projetosCategories',
            'Dzy\Projetos\Components\RssFeed'    => 'projetosRssFeed'
        ];
    }

    public function registerPermissions()
    {
        return [
            'dzy.projetos.access_posts' => [
                'tab'   => 'dzy.projetos::lang.projetos.tab',
                'label' => 'dzy.projetos::lang.projetos.access_posts'
            ],
            'dzy.projetos.access_categories' => [
                'tab'   => 'dzy.projetos::lang.projetos.tab',
                'label' => 'dzy.projetos::lang.projetos.access_categories'
            ],
            'dzy.projetos.access_other_posts' => [
                'tab'   => 'dzy.projetos::lang.projetos.tab',
                'label' => 'dzy.projetos::lang.projetos.access_other_posts'
            ],
            'dzy.projetos.access_import_export' => [
                'tab'   => 'dzy.projetos::lang.projetos.tab',
                'label' => 'dzy.projetos::lang.projetos.access_import_export'
            ],
            'dzy.projetos.access_publish' => [
                'tab'   => 'dzy.projetos::lang.projetos.tab',
                'label' => 'dzy.projetos::lang.projetos.access_publish'
            ]
        ];
    }

    public function registerNavigation()
    {
        return [
            'projetos' => [
                'label'       => 'dzy.projetos::lang.projetos.menu_label',
                'url'         => Backend::url('dzy/projetos/posts'),
                'icon'        => 'icon-pencil',
                'iconSvg'     => 'plugins/dzy/projetos/assets/images/projetos-icon.svg',
                'permissions' => ['dzy.projetos.*'],
                'order'       => 300,

                'sideMenu' => [
                    'new_post' => [
                        'label'       => 'dzy.projetos::lang.posts.new_post',
                        'icon'        => 'icon-plus',
                        'url'         => Backend::url('dzy/projetos/posts/create'),
                        'permissions' => ['dzy.projetos.access_posts']
                    ],
                    'posts' => [
                        'label'       => 'dzy.projetos::lang.projetos.posts',
                        'icon'        => 'icon-copy',
                        'url'         => Backend::url('dzy/projetos/posts'),
                        'permissions' => ['dzy.projetos.access_posts']
                    ],
                    'categories' => [
                        'label'       => 'dzy.projetos::lang.projetos.categories',
                        'icon'        => 'icon-list-ul',
                        'url'         => Backend::url('dzy/projetos/categories'),
                        'permissions' => ['dzy.projetos.access_categories']
                    ]
                ]
            ]
        ];
    }

    public function registerFormWidgets()
    {
        return [
            'Dzy\Projetos\FormWidgets\Preview' => [
                'label' => 'Preview',
                'code'  => 'preview'
            ]
        ];
    }

    /**
     * Register method, called when the plugin is first registered.
     */
    public function register()
    {
        /*
         * Register the image tag processing callback
         */
        TagProcessor::instance()->registerCallback(function($input, $preview) {
            if (!$preview) {
                return $input;
            }

            return preg_replace('|\<img src="image" alt="([0-9]+)"([^>]*)\/>|m',
                '<span class="image-placeholder" data-index="$1">
                    <span class="upload-dropzone">
                        <span class="label">Click or drop an image...</span>
                        <span class="indicator"></span>
                    </span>
                </span>',
            $input);
        });
    }

    public function boot()
    {
        /*
         * Register menu items for the Dzy.Pages plugin
         */
        Event::listen('pages.menuitem.listTypes', function() {
            return [
                'projetos-category'       => 'dzy.projetos::lang.menuitem.projetos_category',
                'all-projetos-categories' => 'dzy.projetos::lang.menuitem.all_projetos_categories',
                'projetos-post'           => 'dzy.projetos::lang.menuitem.projetos_post',
                'all-projetos-posts'      => 'dzy.projetos::lang.menuitem.all_projetos_posts',
            ];
        });

        Event::listen('pages.menuitem.getTypeInfo', function($type) {
            if ($type == 'projetos-category' || $type == 'all-projetos-categories') {
                return Category::getMenuTypeInfo($type);
            }
            elseif ($type == 'projetos-post' || $type == 'all-projetos-posts') {
                return Post::getMenuTypeInfo($type);
            }
        });

        Event::listen('pages.menuitem.resolveItem', function($type, $item, $url, $theme) {
            if ($type == 'projetos-category' || $type == 'all-projetos-categories') {
                return Category::resolveMenuItem($item, $url, $theme);
            }
            elseif ($type == 'projetos-post' || $type == 'all-projetos-posts') {
                return Post::resolveMenuItem($item, $url, $theme);
            }
        });
    }
}
