<?php namespace Dzy\FormContato\Components;
use Cms\Classes\ComponentBase;
use Mail;
use Validator;
use ValidationException;
use ApplicationException;
class Form extends ComponentBase
{
public function componentDetails()
{
return [
'name'        => 'Form',
'description' => 'Formulário',
'icon'        => 'icon-envelope'
];
}
public function onSend()
{
// Collect input
$nome  = post('nome');
$email = post('email');
$msg = post('msg');
// Form Validation
$validator = Validator::make(
[
'nome' => $nome,
'email' => $email,
'msg' => $msg
],
[
'nome' => 'required',
]
);
if ($validator->fails())
{
$messages = $validator->messages();
throw new ApplicationException($messages->first());
}
// Submit form
$params = compact(
'nome',
'email',
'msg'
);
Mail::send('dzy.formcontato::mail.form', $params, function($message)
{
// Message recipient
$message->from(post('email'), post('nome'));
$message->to('vsalonikio@gmail.com');
});
Mail::sendTo($email, 'dzy.formcontato::mail.formthanks', $params);

return true;
}
}