<?php namespace Dzy\Building\Updates;

use Carbon\Carbon;
use Dzy\Building\Models\Post;
use Dzy\Building\Models\Category;
use October\Rain\Database\Updates\Seeder;

class SeedAllTables extends Seeder
{

    public function run()
    {
        Post::create([
            'title' => 'First building post',
            'slug' => 'first-building-post',
            'content' => '
This is your first ever **building post**! It might be a good idea to update this post with some more relevant content.

You can edit this content by selecting **Building** from the administration back-end menu.

*Enjoy the good times!*
            ',
            'excerpt' => 'The first ever building post is here. It might be a good idea to update this post with some more relevant content.',
            'published_at' => Carbon::now(),
            'published' => true
        ]);

        Category::create([
            'name' => trans('dzy.building::lang.categories.uncategorized'),
            'slug' => 'uncategorized',
        ]);
    }

}
