<?php namespace Dzy\Building;

use Backend;
use Controller;
use Dzy\Building\Models\Post;
use System\Classes\PluginBase;
use Dzy\Building\Classes\TagProcessor;
use Dzy\Building\Models\Category;
use Event;

class Plugin extends PluginBase
{
    public function pluginDetails()
    {
        return [
            'name'        => 'dzy.building::lang.plugin.name',
            'description' => 'dzy.building::lang.plugin.description',
            'author'      => 'Andre',
            'icon'        => 'icon-pencil',
            'homepage'    => ''
        ];
    }

    public function registerComponents()
    {
        return [
            'Dzy\Building\Components\Post'       => 'buildingPost',
            'Dzy\Building\Components\Slides'      => 'slides',
            'Dzy\Building\Components\Posts'      => 'buildingPosts',
            'Dzy\Building\Components\Categories' => 'buildingCategories',
            'Dzy\Building\Components\RssFeed'    => 'buildingRssFeed'
        ];
    }

    public function registerPermissions()
    {
        return [
            'dzy.building.access_posts' => [
                'tab'   => 'dzy.building::lang.building.tab',
                'label' => 'dzy.building::lang.building.access_posts'
            ],
            'dzy.building.access_categories' => [
                'tab'   => 'dzy.building::lang.building.tab',
                'label' => 'dzy.building::lang.building.access_categories'
            ],
            'dzy.building.access_other_posts' => [
                'tab'   => 'dzy.building::lang.building.tab',
                'label' => 'dzy.building::lang.building.access_other_posts'
            ],
            'dzy.building.access_publish' => [
                'tab'   => 'dzy.building::lang.building.tab',
                'label' => 'dzy.building::lang.building.access_publish'
            ]
        ];
    }

    public function registerNavigation()
    {
        return [
            'building' => [
                'label'       => 'dzy.building::lang.building.menu_label',
                'url'         => Backend::url('dzy/building/posts'),
                'icon'        => 'icon-pencil',
                'iconSvg'     => 'plugins/dzy/building/assets/images/building-icon.svg',
                'permissions' => ['dzy.building.*'],
                'order'       => 300,

                'sideMenu' => [
                    'new_post' => [
                        'label'       => 'dzy.building::lang.posts.new_post',
                        'icon'        => 'icon-plus',
                        'url'         => Backend::url('dzy/building/posts/create'),
                        'permissions' => ['dzy.building.access_posts']
                    ],
                    'posts' => [
                        'label'       => 'dzy.building::lang.building.posts',
                        'icon'        => 'icon-copy',
                        'url'         => Backend::url('dzy/building/posts'),
                        'permissions' => ['dzy.building.access_posts']
                    ],
                    'categories' => [
                        'label'       => 'dzy.building::lang.building.categories',
                        'icon'        => 'icon-list-ul',
                        'url'         => Backend::url('dzy/building/categories'),
                        'permissions' => ['dzy.building.access_categories']
                    ]
                ]
            ]
        ];
    }

    public function registerFormWidgets()
    {
        return [
            'Dzy\Building\FormWidgets\Preview' => [
                'label' => 'Preview',
                'code'  => 'preview'
            ]
        ];
    }

    /**
     * Register method, called when the plugin is first registered.
     */
    public function register()
    {
        /*
         * Register the image tag processing callback
         */
        TagProcessor::instance()->registerCallback(function($input, $preview) {
            if (!$preview) {
                return $input;
            }

            return preg_replace('|\<img src="image" alt="([0-9]+)"([^>]*)\/>|m',
                '<span class="image-placeholder" data-index="$1">
                    <span class="upload-dropzone">
                        <span class="label">Click or drop an image...</span>
                        <span class="indicator"></span>
                    </span>
                </span>',
            $input);
        });
    }

    public function boot()
    {
        /*
         * Register menu items for the Dzy.Pages plugin
         */
        Event::listen('pages.menuitem.listTypes', function() {
            return [
                'building-category'       => 'dzy.building::lang.menuitem.building_category',
                'all-building-categories' => 'dzy.building::lang.menuitem.all_building_categories',
                'building-post'           => 'dzy.building::lang.menuitem.building_post',
                'all-building-posts'      => 'dzy.building::lang.menuitem.all_building_posts',
            ];
        });

        Event::listen('pages.menuitem.getTypeInfo', function($type) {
            if ($type == 'building-category' || $type == 'all-building-categories') {
                return Category::getMenuTypeInfo($type);
            }
            elseif ($type == 'building-post' || $type == 'all-building-posts') {
                return Post::getMenuTypeInfo($type);
            }
        });

        Event::listen('pages.menuitem.resolveItem', function($type, $item, $url, $theme) {
            if ($type == 'building-category' || $type == 'all-building-categories') {
                return Category::resolveMenuItem($item, $url, $theme);
            }
            elseif ($type == 'building-post' || $type == 'all-building-posts') {
                return Post::resolveMenuItem($item, $url, $theme);
            }
        });
    }
}
